* Program....: PROJSCAN.PRG
* Version....: 1.0
* Author.....: Ted Roche, MCSD
* Date.......: Tuesday July 29, 1997
* Notice.....: Copyright (c) 1997 Ted Roche All Rights Reserved.
* Compiler...: FoxPro 2.6a for Windows
* Abstract...: Scan a project, build up a cursor of information
* Changes....:  && tr - 07/31/1997 16:02:11 - added vfp stuff
* ...........: 09/10/1998 - removed VFP-specific LOCALS
* ...........:   && tr - 02/01/2000 18:52:39 - added (M)enus, (T) - headers, 
* ...........: 7 February 2000 - attempts to modify into a working project.
* ...........: 1st problem: can't find files. Must grab path from project.

NOTE: This is a 2.x version, assuming that SPRs contain code
NOTE: VFP appears to solve this problem by using different 
*     type codes

PARAMETERS tcProject
private lcSetTalk, lcSetDeleted, lnSetDeci, lcProject, X, Y
private lcPath, lcPJXPath
private lnCode, lnComment, lnCount
private lcSetExcl


lcSetTalk = SET("TALK")
if lcSetTalk = "ON"
  set talk off
endif

lcSetDeleted = set("deleted")
set deleted on

lcSetExcl = SET("EXCLUSIVE")
SET EXCLUSIVE OFF

close data all
activate screen
clear

* See if a project file was passed in
IF TYPE("tcProject") = "C" AND FILE(tcProject)
  lcProject = tcProject
ELSE
  lcProject = GETFILE("PJX","Select Project", "Select")
ENDIF

IF EMPTY(lcProject) or NOT FILE(lcProject)
  return
endif

use (lcProject) excl noupdate alias Proj
? "Analyzing Project " + fullpath(lcProject)
? 
* File count
select count(*) as nTypeCount, ;
       SourcePJX.type as TypeChar,  ;
       PADR(WhatType(SourcePJX.type),14) as WhatType, ;
       000000 as nCode, ;
       000000 as nComment, ;
       0000.00 as nRatio ;
  from (lcProject) SourcePJX;
 group by 2 ;
 order by 3 ;
  into cursor Fred2 NOFILTER
  
select 0
USE DBF("Fred2") AGAIN ALIAS Fred  && make read-write
  
*!*	scan
*!*	  ? "Type: " + Fred.WhatType + ;
*!*	    " Count: " + transform(Fred.TypeCount,"@R 9,999")
*!*	endscan

* create cursor Temp (filename M,type c(1), code n(5), comment n(5))

sele Proj
lcPath = ADDBS(JustPath(FullPath(lcProject)))

* scan
scan && for Proj.Type ="V"  && **** DEBUGGING ONLY !!! ***

  do case
    case Proj.Type = "H" &&  Header; skip
      * Grab the path
      lcPJXPath = ADDBS(ALLTRIM(STRTRAN(Proj.HomeDir, CHR(0))))
      * Detect if the project has been moved, retain current path
      if lcPJXPath <> lcPath
        ? "Project home directory: " + lcPath
      endif
      
    case INLIST(Proj.Type, "P", "S", "E")  && SPR file
      * Program: measure
      IF FILE(alltrim(lcPath + Proj.Name))
        store 0 to lnCode, lnComment
        wait window nowait "Type: " + Proj.Type + " " + Proj.Name
        do remcount with alltrim(lcPath + Proj.Name), lnCode, lnComment  && tr - 02/07/2000 14:27:49
        * insert into Temp values (Proj.Name, Proj.Type, nCode, nComment)
        UPDATE Fred Set Fred.nCode = Fred.nCode + lnCode, ;
                        Fred.nComment = Fred.nComment + lnComment ;
                  WHERE Fred.TypeChar = Proj.Type
      ELSE
        ? "File " + alltrim(lcPath + Proj.Name) + " missing."
      ENDIF

    CASE Proj.Type = "V"  && VCX - class library
      wait window nowait "Type: " + Proj.Type + " " + Proj.Name
      IF FILE(lcPath + Proj.Name)
      lnSelect = SELECT()
      select 0
      use (alltrim(lcPath + Proj.Name)) noupdate alias ClassLib
      SCAN FOR NOT EMPTY(OBJNAME)
        store 0 to lnCode, lnComment
        if not empty(Classlib.Methods)
          do remcount with alltrim(ObjName), lnCode, lnComment, ALLTRIM(Classlib.Methods)
          UPDATE Fred Set Fred.nCode = Fred.nCode + lnCode, ;
                          Fred.nComment = Fred.nComment + lnComment ;
                    WHERE Fred.TypeChar = Proj.Type
        endif
        * insert into temp values (ClassLib.Objname, Proj.Type, nCode, nComment)
      endscan
      use
      select (lnSelect)
      ELSE
        ? "File " + alltrim(lcPath + Proj.Name) + " missing."
      ENDIF
      
    CASE Proj.Type = "K"  && SCX - VFP Form
      wait window nowait "Type: " + Proj.Type + " " + Proj.Name
      IF FILE(alltrim(lcPath + Proj.Name))
      lnSelect = SELECT()
      select 0
      use (alltrim(lcPath + Proj.Name)) noupdate alias FormTable
      SCAN FOR NOT EMPTY(OBJNAME)
        store 0 to lnCode, lnComment
        if not empty(FormTable.Methods)
          do remcount with alltrim(ObjName), lnCode, lnComment, ALLTRIM(FormTable.Methods)
           UPDATE Fred Set Fred.nCode = Fred.nCode + lnCode, ;
                           Fred.nComment = Fred.nComment + lnComment ;
                     WHERE Fred.TypeChar = Proj.Type
          
        endif
        * insert into temp values (FormTable.Objname, Proj.Type, nCode, nComment)
      endscan
      use
      select (lnSelect)
      ELSE
        ? "File " + alltrim(lcPath + Proj.Name) + " missing."
      ENDIF

    CASE Proj.Type = "M"  && menu
      wait window nowait "Type: " + Proj.Type + " " + Proj.Name
      IF FILE(alltrim(lcPath + Proj.Name))
      lnSelect = SELECT()
      select 0
      use (alltrim(lcPath + Proj.Name)) noupdate alias MenuTable
      SCAN 
        store 0 to lnCode, lnComment
        if not empty(MenuTable.Setup)  && Setup, Cleanup, Procedure
          do remcount with alltrim(MenuTable.Name), lnCode, lnComment, ALLTRIM(MenuTable.Setup)
          UPDATE Fred Set Fred.nCode = Fred.nCode + lnCode, ;
                          Fred.nComment = Fred.nComment + lnComment ;
                    WHERE Fred.TypeChar = Proj.Type
          * insert into temp values (MenuTable.Name, Proj.Type, nCode, nComment)
        endif
        if not empty(MenuTable.Cleanup)  && Setup, Cleanup, Procedure
          do remcount with alltrim(MenuTable.Name), lnCode, lnComment, ALLTRIM(MenuTable.Cleanup)
          UPDATE Fred Set Fred.nCode = Fred.nCode + lnCode, ;
                          Fred.nComment = Fred.nComment + lnComment ;
                    WHERE Fred.TypeChar = Proj.Type
          * insert into temp values (MenuTable.Name, Proj.Type, nCode, nComment)
        endif
        if not empty(MenuTable.Procedure)  && Setup, Cleanup, Procedure
          do remcount with alltrim(MenuTable.Name), lnCode, lnComment, ALLTRIM(MenuTable.Procedure)
          UPDATE Fred Set Fred.nCode = Fred.nCode + lnCode, ;
                          Fred.nComment = Fred.nComment + lnComment ;
                    WHERE Fred.TypeChar = Proj.Type
          * insert into temp values (MenuTable.Name, Proj.Type, nCode, nComment)
        endif
      endscan
      use
      select (lnSelect)
      ELSE
        ? "File " + alltrim(lcPath + Proj.Name) + " missing."
      ENDIF

    otherwise
      * skip for this project
    endcase
endscan

* select Temp
* set talk on
activate screen
select Fred
scan
  ? "Type: " + Fred.WhatType + ;
    " Count: " + transform(Fred.nTypeCount,"@R 9,999") + ;
    " Code: " + transform(Fred.nCode,"@R 999,999") + ;
    " Comments: " + transform(Fred.nComment,"@R 999,999") + ;
    " Ratio: " + IIF(Fred.nComment = 0, "      *", ;
                 transform(Fred.nCode/Fred.nComment, "999.999"))
endscan
calculate sum(Fred.nTypeCount), sum(NCode), sum(NComment) to lnCount, lnCode, lnComment
  ? "Totals: " + SPACE(12) + ;
    " Count: " + transform(lnCount,"@R 9,999") + ;
    " Code: " + transform(lnCode,"@R 999,999") + ;
    " Comments: " + transform(lnComment,"@R 999,999") + ;
    " Ratio: " + IIF(lnComment = 0, "      *", ;
                 transform(lnCode/lnComment, "999.999"))

* local lnSetDeci
*!*	lnSetDeci = SET("DECIMALS")
*!*	SET DECIMALS TO 10
* LOCAL X, Y  && tr - 09/10/1998 10:25:04
*!*	? 
*!*	?
*!*	? "Code Lines    Comment Lines            Ratio"
*!*	? "Screens:"
*!*	calculate sum(Code), sum(Comment) for type="S" or type = "K" to X,Y
*!*	? X,Y,X/Y
*!*	? "Programs:"
*!*	calculate sum(Code), sum(Comment) for type="P" to X,Y
*!*	? X,Y,X/Y
*!*	? "Menus:"
*!*	calculate sum(Code), sum(Comment) for type="M" to X,Y
*!*	? X,Y,X/Y
*!*	? "Classes:"
*!*	calculate sum(Code), sum(Comment) for type="V" to X,Y
*!*	? X,Y,X/Y
*!*	? "Totals:"
*!*	calculate sum(Code), sum(Comment) to X,Y
*!*	? X,Y,X/Y

* SET DECIMALS TO (LNsETdECI)
set talk &lcSetTalk
set deleted &lcSetDeleted
SET EXCLUSIVE &lcSetExcl
*!*	use in Fred
*!*	use in Fred2
*!*	use in Proj

return

Procedure WhatType
parameter tcChar
private lcReturn
do case
  case type("tcChar") <> "C" or empty(tcChar)
    lcReturn = "Invalid Parameter"

  case tcChar = "B"
    lcReturn = "Label"
  case tcChar = "D"
    lcReturn = "DBF Table"
  case tcChar = "d"
    lcReturn = "DBC Database"
  case tcChar = "E"
    lcReturn = "2.x Screen SPR"
  case tcChar = "H"
    lcReturn = "PJX Header"
  case tcChar = "I"
    lcReturn = "Icon"
  case tcChar = "i"
    lcReturn = "Icon"
  case tcChar = "K"
    lcReturn = "VFP Form"
  case tcChar = "L"
    lcReturn = "Library"
  case tcChar = "M"
    lcReturn = "Menu"
  case tcChar = "P"
    lcReturn = "Program"
  case tcChar = "R"
    lcReturn = "Report"
  case tcChar = "s"
    lcReturn = "SCX Screen Source"
  case tcChar = "S"
    lcReturn = "SPR Generated Screen"
  case tcChar = "T"
    lcReturn = "Header Include"
  case tcChar = "V"
    lcReturn = "Class Library"
  case tcChar = "W"
    lcReturn = "Project Hook"
  case tcChar = "x"
    lcReturn = "Other"
  case tcChar = "Z"
    lcReturn = "APP file"
  otherwise
    lcReturn = "Unknown type " + tcChar
endcase
return lcReturn

* JustPath - stolen from FPW GenScrn for backward compatibility
*!*****************************************************************************
*!
*!       Function: JUSTPATH
*!
*!      Called by: FORCEEXT()         (function  in GENSCRN.PRG)
*!
*!*****************************************************************************
FUNCTION justpath
*)
*) JUSTPATH - Returns just the pathname.
*)
PARAMETERS m.filname
m.filname = ALLTRIM(UPPER(m.filname))
IF '\' $ m.filname
   m.filname = SUBSTR(m.filname,1,RAT('\',m.filname))
   IF RIGHT(m.filname,1) = '\' AND LEN(m.filname) > 1 ;
            AND SUBSTR(m.filname,LEN(m.filname)-1,1) <> ':'
         filname = SUBSTR(m.filname,1,LEN(m.filname)-1)
   ENDIF
   RETURN m.filname
ELSE
   RETURN ''
ENDIF

* AddBS - stolen from FPW GenScrn for backward compatibility
*!*****************************************************************************
*!
*!       Function: ADDBS
*!
*!      Called by: FORCEEXT()         (function  in GENSCRN.PRG)
*!
*!*****************************************************************************
FUNCTION addbs
*)
*) ADDBS - Add a backslash unless there is one already there.
*)
PARAMETER m.pathname
PRIVATE m.separator
m.separator = IIF(_MAC,":","\")
m.pathname = ALLTRIM(UPPER(m.pathname))
IF !(RIGHT(m.pathname,1) $ '\:') AND !EMPTY(m.pathname)
   m.pathname = m.pathname + m.separator
ENDIF
RETURN m.pathname
