**********************************************************************
* Program....: RSS10GEN.PRG
* Version....:
* Author.....: Ted Roche
* Date.......: 09 December 2003, 17:23:38
* Notice.....: Copyright  2003 by Ted Roche, under the 
* ...........: Creative Commons Attribution - ShareAlike 1.0 license
* ...........: http://creativecommons.org/licenses/by-sa/1.0/
* Compiler...: Visual FoxPro 08.00.0000.3117 for Windows
* Abstract...: Generate RSS 1.0 from incoming cursors
* Changes....:
* Parameters.:
* Purpose....: 
********************************************************************************************************************************************
* Originally released as RSS20Gen, which it is not.
* 9-Dec-2003 - fixed CDATA encoding for description tag

RETURN .t.  && comment out for testing

* Inputs: Cursors of channel header information
*         Cursor of new itesm

* Outputs: RSS XML string

*** TEST HEADER ***
CREATE CURSOR curHeader (cTitle c(40), cLink c(254), mDesc M)
INSERT INTO curHeader (cTitle, cLink, mDesc) VALUES ;
                      ("The FoxForum Wiki", ;
                       "http://fox.wikis.com", ;
                       "The online community for interactive and persistant FoxPro knowledge." ;
                       )
*** TEST ITEMS ***
CREATE CURSOR curItem (title c(40), description M, link c(254), updated T)
INSERT INTO curItem VALUES ("Test Item #1", "This is the body of test item #1.", "http://example.com/1", DATETIME())
INSERT INTO curItem VALUES ("Test Item #2", "This is the body of test item #2.", "http://example.com/2", DATETIME())
INSERT INTO curItem VALUES ("Test Item #3", "This is the body of test item #3.", "http://example.com/3", DATETIME())

loGenRSS = CREATEOBJECT("RSS10Generator")
loXMl = loGenRSS.ProcessRSS()
lcOutputFileName = "testrss10.rdf"
lcOutputFileName = FULLPATH(lcOutputFilename)
loXML.Save(lcOutputFilename)
* STRTOFILE(loXML.xml, lcOutputFilename)
MODIFY FILE (lcOutputFilename)
ShellExe(lcOutputFilename)  && ShellExe is a UDF to invoke the 
* Win32API ShellExecute function

***********************************************************
* Class Definition: RSS10Generator
***********************************************************

DEFINE CLASS RSS10Generator as Custom
oXML = NULL

********
* Init *
********
PROCEDURE Init

ENDPROC && Init

********************************
* ProcessRSS()                 *
* Template processing method   *
********************************

PROCEDURE ProcessRSS()
THIS.CreateDoc()
THIS.AddChannelInfo()
THIS.AddHeaderItems()
THIS.AddBodyItems()
RETURN THIS.oXML

ENDPROC && ProcessRSS

*************
* CreateDoc *
*************
* Creates the base XMLDOM object, 
* XML declaration,
* RDF root
* and namespace declarations
*

PROCEDURE CreateDoc()

LOCAL loXML as MSXML.DOMDocument40
LOCAL loDocument, loAttribute

loXML = newobject('msxml2.domdocument.4.0')
loXml.async = .f.

* Create the RDF root and load namespaces
loNewItem = loXML.CreateProcessingInstruction([xml], [version='1.0' encoding='iso-8859-1'])
loXML.appendChild(loNewItem)

loDocument = loXml.createElement('rdf:RDF')  && was ('RDF:rdf')
loXML.appendChild(loDocument)

* Add the standard RDF namespace
loAttribute = loXML.createAttribute([xmlns:rdf])
loAttribute.value="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
loDocument.attributes.setNamedItem(loAttribute)

* Add the Dublin Core namespace - see URL for documentation
loAttribute = loXML.createAttribute("xmlns:dc")
loAttribute.value="http://purl.org/dc/elements/1.1/"
loDocument.attributes.setNamedItem(loAttribute)

* Add the Syndication namespace - see URL for documentation
loAttribute = loXML.createAttribute("xmlns:sy")
loAttribute.value="http://purl.org/rss/1.0/modules/syndication/"
loDocument.attributes.setNamedItem(loAttribute)

* Add the Administrative namespace - see URL for documentation
loAttribute = loXML.createAttribute("xmlns:admin")
loAttribute.value="http://webns.net/mvcb/"
loDocument.attributes.setNamedItem(loAttribute)

* Creative Commons license - not applicable here
*!*	loAttribute = loXML.createAttribute("xmlns:cc")
*!*	loAttribute.value="http://web.resource.org/cc/"
*!*	loDocument.attributes.setNamedItem(loAttribute)

* Add the RSS namespace
loAttribute = loXML.createAttribute("xmlns")
loAttribute.value="http://purl.org/rss/1.0/"
loDocument.attributes.setNamedItem(loAttribute)

* Release object references
STORE null TO loAttribute, loDocument

* Store the XMLDOM object 
THIS.oXml = loXML

ENDPROC && CreateDoc()

******************
* AddChannelInfo *
******************
* Builds the channel element 
* from the curHeader cursor
*

PROCEDURE AddChannelInfo

LOCAL loXML, loElement, loAttribute, loChannel, loDocument
loXML = THIS.oXML
loDocument = loXML.childNodes.item(1)

* Add the channel sub-element
loElement = loXML.createElement("channel")
loAttribute = loXML.createAttribute("rdf:about")
loAttribute.value = ALLTRIM(curHeader.cLink)  && "http://fox.wikis.com/"
loElement.attributes.setNamedItem(loAttribute)
loChannel = loDocument.appendChild(loElement)

* Add the title sub-element
loElement = loXML.createElement("title")
loElement.nodeTypedValue = curHeader.cTitle  && "FoxForum Wiki"
loChannel.appendChild(loElement)

* Add the link sub-element
loElement = loXML.createElement("link")
loElement.nodeTypedValue = ALLTRIM(curHeader.cLink) && "http://fox.wikis.com/"
loChannel.appendChild(loElement)

* Add the description sub-element
loElement = loXML.createElement("description")
loElement.nodeTypedValue = curHeader.mDesc && "Visual FoxPro Wiki, community supported knowledgebase"
loChannel.appendChild(loElement)

* Add the language sub-element
loElement = loXML.createElement("dc:language")
loElement.nodeTypedValue = "en-us"
loChannel.appendChild(loElement)

* Add the creator sub-element
loElement = loXML.createElement("dc:creator")
loElement.nodeTypedValue = " "
loChannel.appendChild(loElement)

* Add the date sub-element
loElement = loXML.createElement("dc:date")
loElement.nodeTypedValue = ISO8601DateTime(DATETIME())
loChannel.appendChild(loElement)

* Add the generatorAgent sub-element
loElement = loXML.createElement("admin:generatorAgent")
* loElement.nodeTypedValue = "http://msdn.microsoft.com/vfoxpro"
loAttribute = loXML.createAttribute("rdf:resource")
loAttribute.value = "http://msdn.microsoft.com/vfoxpro"
loElement.attributes.setNamedItem(loAttribute)
loChannel.appendChild(loElement)

* Add the errorReportsTo sub-element
loElement = loXML.createElement("admin:errorReportsTo")
* loElement.nodeTypedValue = "mailto:tedroche@tedroche.com"
loAttribute = loXML.createAttribute("rdf:resource")
loAttribute.value = "mailto:tedroche@tedroche.com"
loElement.attributes.setNamedItem(loAttribute)
loChannel.appendChild(loElement)

ENDPROC && AddChannelInfo

******************
* AddHeaderItems *
******************
* Adds the Items sub-element (//RDF/channel/Items)
* that lists the links for each item to follow
* in the body of the RSS
*

PROCEDURE AddHeaderItems()
LOCAL loXML, loElement, loItems, loRdfSEQ, loChannel
loXML = THIS.oXML
loChannel = loXML.selectSingleNode("//RDF/channel")

* Add the Items list to the header
* Add the element Items
NOTE: Disagreement over whether this is a capitalized
* element or not. Changed to lowercase to pass
* http://feedvalidator.org test. -- 5-Sept-2003 - tr

loElement = loXML.createElement("items")

loItems = loChannel.appendChild(loElement)

* Add the sub-element rdf:Seq
loElement = loXML.createElement("rdf:Seq")
loRdfSeq = loItems.appendChild(loElement)

* Add each rdf:li
SELECT CurItem
SCAN  && curItem

loElement = loXML.createElement("rdf:li")
loAttribute = loXML.createAttribute("rdf:resource")
loAttribute.value=ALLTRIM(CurItem.Link)
loElement.attributes.setNamedItem(loAttribute)
loRdfSeq.appendChild(loElement)

ENDSCAN  && curItem
loRdfSeq = NULL
liItems = NULL
loChannel = NULL
ENDPROC && AddHeaderItems

****************
* AddBodyItems *
****************
* Adds the individual items for each
* article

PROCEDURE AddBodyItems()

LOCAL loXML, loElement, loAttribute, loItem, loDocument, loCDATA
loXML = THIS.oXML
loDocument = loXML.selectSingleNode("//RDF")

* Add Items to body
SELECT CurItem
SCAN  && curItem

loElement = loXML.createElement("item")
loAttribute = loXML.createAttribute("rdf:about")
loAttribute.value=ALLTRIM(CurItem.Link)
loElement.attributes.setNamedItem(loAttribute)
loItem = loDocument.appendChild(loElement)

* Add the title sub-element
loElement = loXML.createElement("title")
loElement.nodeTypedValue = ALLTRIM(CurItem.title)
loItem.appendChild(loElement)

* Add the description sub-element
loElement = loXML.createElement("description")
loCDATA = loXML.createCDATASection(ALLTRIM(curItem.Description))
* loElement.nodeTypedValue = "<![CDATA[" + ALLTRIM(curItem.Description) + "]]>"
* loElement.nodeType = 4  && #DEFINE NODE_CDATA_SECTION	4
* loElement.nodeTypedValue = loCDATA.xml
* loCData.nodeName = "description"
loElement.appendChild(loCDATA)
loItem.appendChild(loElement)

* Add the link sub-element
loElement = loXML.createElement("link")
loElement.nodeTypedValue = ALLTRIM(CurItem.Link)
loItem.appendChild(loElement)

* Add the creator sub-element
loElement = loXML.createElement("dc:creator")
loElement.nodeTypedValue = "Unknown"
loItem.appendChild(loElement)

* Add the date sub-element
loElement = loXML.createElement("dc:date")
loElement.nodeTypedValue = ISO8601DateTime(DATETIME())
loItem.appendChild(loElement)

ENDSCAN  && curItem

ENDPROC && AddBodyItems()

******************
* Error handling *
******************

PROCEDURE Error(tnError, tcMethod, tnLine)
LOCAL lcError as String
lcError = CHR(13)+CHR(10) + TTOC(DATETIME()) + CHR(13)+CHR(10) + ;
          "Error " + TRANSFORM(tnError) + ;
          " in method " + tcMethod + ;
          " at line " + TRANSFORM(tnLine)
          
IF SYS(2335) = '1'  OR ; && unattended server mode
   VERSION(2) = 0 OR ; && runtime version
   _screen.Visible= .F.
   
  * Log the error to disk
  STRTOFILE(lcError, JUSTSTEM(SYS(16))+".err", .T.)
  QUIT 
ELSE  && not hidden
  MESSAGEBOX(lcError)
  CANCEL
ENDIF


ENDPROC && Error()

ENDDEFINE && CLASS RSS10Generator as Custom
