* READURL.PRG - return the HTML for a specified URL 
*
* passed: URLName, in the form "http://www.microsoft.com"
*
* returns: Content
*
* usage:
*
*      ? readurl("http://www.microsoft.com")
*
*
* notes:
* 1 - IE does not need to be running to use this, but must be installed,
* as the program uses an option that gets information from the registry
*
* 2 - the URL name apparently MUST be passed in the form shown above.
*

PARAMETERS UrlName

DECLARE INTEGER InternetOpen IN wininet.DLL STRING sAgent, ;
  INTEGER lAccessType, STRING sProxyName, ;
  STRING sProxyBypass, INTEGER lFlags

DECLARE INTEGER InternetOpenUrl IN wininet.DLL ;
  INTEGER hInternetSession, STRING sUrl, STRING sHeaders, ;
  INTEGER lHeadersLength, INTEGER lFlags, INTEGER lContext

DECLARE INTEGER InternetReadFile IN wininet.DLL INTEGER hfile, ;
  STRING @sBuffer, INTEGER lNumberofBytesToRead, INTEGER @lBytesRead

DECLARE short InternetCloseHandle IN wininet.DLL INTEGER hInst

#DEFINE INTERNET_OPEN_TYPE_PRECONFIG 0
#DEFINE INTERNET_OPEN_TYPE_DIRECT 1
#DEFINE INTERNET_OPEN_TYPE_PROXY 3
#DEFINE SYNCHRONOUS 0
#DEFINE INTERNET_FLAG_RELOAD 2147483648
#DEFINE CR CHR(13)


*!*	   IF NOT FILE("hurl.dbf")
*!*	         CREATE TABLE hurl (MEMO M)
*!*	   ELSE
*!*	         USE hurl
*!*	   ENDIF
*!*	   APPEND BLANK
*!*	IF USED("Hurl")
*!*	  SELECT ("Hurl")
*!*	ELSE
*!*	  CREATE CURSOR hurl (Memo M)
*!*	ENDIF
*!*	APPEND blank
LOCAL lcContents AS STRING, ;
  sAgent AS STRING, ;
  hInternetSession AS INTEGER, ;
  hURLFile AS INTEGER, ;
  sReadBuffer AS STRING, ;
  lBytesRead AS INTEGER, ;
  m.OK AS INTEGER

lcContents = SPACE(0)


* what application is using Internet services?
sAgent = VERSION()  && "VPF 5.0"

hInternetSession = InternetOpen(sAgent, INTERNET_OPEN_TYPE_PRECONFIG, ;
  '', '', SYNCHRONOUS)

* debugging line - uncomment to see session handle
* WAIT WINDOW "Internet session handle: " + LTRIM(STR(hInternetSession))

IF hInternetSession = 0
  *   WAIT WINDOW "Internet session cannot be established" TIME 2
  ERROR "Internet session cannot be established"
  RETURN 0
ENDIF

hURLFile = InternetOpenUrl(hInternetSession, UrlName, '', ;
  0, INTERNET_FLAG_RELOAD, 0)

* debugging line - uncomment to see URL handle
* WAIT WINDOW "URL Handle: " + LTRIM(STR(hUrlFile))

IF hURLFile = 0
  * WAIT WINDOW "URL cannot be opened"
  ERROR "URL cannot be opened"
  RETURN 0
ENDIF

DO WHILE .T.
  * set aside a big buffer
  sReadBuffer = SPACE(256*1024)
  lBytesRead = 0
  m.OK = InternetReadFile(hURLFile, @sReadBuffer, ;
    LEN(sReadBuffer), @lBytesRead)

  * debugging code - uncomment if necessary
  *WAIT WINDOW "hURLFile: " + LTRIM(STR(hURLFile)) + CR + ;
  *                  "lBytesRead: " + LTRIM(STR(lBytesRead)) + CR ;
  *                  + "m.OK      : " + LTRIM(STR(m.OK))

  lcContents = lcContents + sReadBuffer

  * REPLACE hurl.MEMO WITH sReadBuffer ADDITIVE

  * uncomment to watch the changes to the memo file
  * MODIFY MEMO hurl.memo

  * error trap - either a read failure or read past eof()
  IF m.OK = 0 OR lBytesRead = 0
    EXIT
  ENDIF
ENDDO

* close all the handles we opened
=InternetCloseHandle(hURLFile)
=InternetCloseHandle(hInternetSession)

* return the number of bytes read
* RETURN LEN(hurl.memo)

* Return, instead, the actual string
RETURN ALLTRIM(lcContents)

