*==============================================================================
* Program:				XMLDateTime
* Purpose:				
* Author:				Ted Roche
* Copyright:			(c) 2003 
* Last revision:		Wednesday, March 26, 2003, 8:52:33 AM
* Parameters:			
* Returns:				
* Environment in:		
* Environment out:		
*==============================================================================
* Completely revised code, courtesty of 
* Andrew Coates, posted
* http://fox.wikis.com/wc.dll?Wiki~XMLDateTime

* FUNCTION csXMLDateTime(tDateTime as Datetime) as String
LPARAMETERS tDateTime as Datetime

* Returns "Thu, 27 Feb 2003 14:11:12 GMT"

* get the UTC offset -- No need to fake the TZ
DECLARE integer GetTimeZoneInformation IN Win32API ;
   STRING @ TimeZoneStruct
   
lcTZStruct = SPACE(256)

lnSunTime = GetTimeZoneInformation(@lcTZStruct )

lnUTCOffset = WordToInt(SUBSTR(lcTZStruct ,1,4), .t.)
lnDaylightBias = WordToInt(RIGHT(ALLTRIM(lcTZStruct), 4), .t.)

* Add the bias if daylight savings is active
IF lnSunTime = 2
   lnUTCOffset = lnUTCOffset + lnDaylightBias
ENDIF

* convert the offset to seconds
lnUTCOffset = lnUTCOffset * 60

ltUTCTime = tDateTime + lnUTCOffset

LOCAL lcReturn as String

lcReturn = LEFT(PROPER(CDOW(ltUTCTime)),3) +", "
lcReturn = lcReturn + PADL(DAY(ltUTCTime),2,'0') + SPACE(1)
lcReturn = lcReturn + LEFT(PROPER(CMONTH(ltUTCTime)),3) + SPACE(1)
lcReturn = lcReturn + STR(YEAR(ltUTCTime),4)+SPACE(1)
lcReturn = lcReturn + STUFF(STUFF(RIGHT(TTOC(ltUTCTime,1), 6), 5, 0, ":"), 3, 0, ":") + SPACE(1)
lcReturn = lcReturn + "GMT"
  
RETURN lcReturn

endfunc


************************************************************************

FUNCTION WordToInt(tcWordString, tlSigned)

LOCAL lcHexString as String, lnResult as Integer, lnChar as Integer
lcHexString = '0x'

FOR lnChar = LEN(tcWordString) TO 1 STEP -1
  lcHexString = lcHexString + PADL(right(TRANSFORM(ASC(SUBSTR(tcWordString, lnChar, 1)), '@0'), 2), 2, '0')
ENDFOR

lnResult = EVALUATE(lcHexString)
IF tlSigned and lnResult > 0x80000000
  lnResult = lnResult - 1 - 0xFFFFFFFF
ENDIF


RETURN lnResult

ENDFUNC
*!*	* FUNCTION XMLDateTime(tDateTime AS DATETIME) AS STRING
*!*	LPARAMETERS tDateTime AS DATETIME

*!*	* Returns "Thu, 27 Feb 2003 14:11:12 GMT"
*!*	LOCAL lcReturn AS STRING, lcTime AS STRING
*!*	lcReturn = LEFT(PROPER(CDOW(tDateTime)),3) +", "
*!*	lcReturn = lcReturn + PADL(DAY(tDateTime),2,'0') + SPACE(1)
*!*	lcReturn = lcReturn + LEFT(PROPER(CMONTH(tDateTime)),3) + SPACE(1)
*!*	lcReturn = lcReturn + STR(YEAR(tDateTime),4)+SPACE(1)

*!*	lcTime = TTOC(DATETIME(),2)  && HH:MM:SS PM
*!*	* Compensate for PM
*!*	IF RIGHT(lcTime,2) = "PM" AND LEFT(lcTime,2) # "12"
*!*	  lcTime = STR(12+VAL(lcTime),2)+SUBSTR(lcTime, 3, 6)
*!*	ELSE
*!*	  lcTime = LEFT(lcTime, 8)
*!*	ENDIF
*!*	* Fake the time zone
*!*	lcTime = lcTime + " EST"

*!*	lcReturn = lcReturn + lcTime

*!*	RETURN lcReturn
*!*	* ENDFUNC && XMLDateTime