*==============================================================================
* Program:				FOXWIKIRSS10.PRG
* Purpose:				Generate a FoxWiki RSS 1.0 file
* Author:				Ted Roche
* Copyright:			(c) 2003
* Last revision:		Tuesday, 19 August, 2003
* Parameters:
* Returns:
* Environment in:
* Environment out:
NOTE Adopted from MakeFoxWikiRSS.PRG, the RSS 2.0 program
*==============================================================================
LOCAL lcXML AS STRING, ;
  lcFileName AS STRING, ;
  lcContents AS STRING, ;
  lcWebPage AS STRING, ;
  lcText AS STRING, ;
  lcSafety as String 

IF VERSION(2) = 0 && runtime
  SYS(2335,0) && set unattended server mode
ENDIF && runtime

TRY  && wrap entire process in TRY...CATCH and dump error if occurs
* There is no try. Do or do not.

CLOSE DATABASES ALL

*******************************************************
*** Read the Recent Changes in XML via Web Services ***
*******************************************************

LOCAL lowikiwebservice AS "XML Web Service"
* LOCAL lowikiwebservice AS "MSSOAP.SoapClient30"
* Do not remove or alter following line. It is used to support IntelliSense for your XML Web service.
*__VFPWSDef__: lowikiwebservice = http://fox.wikis.com/wikiwebservice.wsdl , wikiwebservice , wikiwebserviceSoapPort
LOCAL loException, lcErrorMsg, loWSHandler
	loWSHandler = NEWOBJECT("WSHandler",IIF(VERSION(2)=0,"",HOME()+"FFC\")+"_ws3client.vcx")
	lowikiwebservice = loWSHandler.SetupClient("http://fox.wikis.com/wikiwebservice.wsdl", "wikiwebservice", "wikiwebserviceSoapPort")
	* Call your XML Web service here.  ex: leResult = lowikiwebservice.SomeMethod()
	
	lcWebPage = lowikiwebservice.GetRecentChanges(1,"")

IF EMPTY(lcWebPage)  && RECCOUNT("Hurl") = 0
  ERROR "Failed to read the URL"
  RETURN .F.
ENDIF

* Convert to a "Topics" cursor
* XMLTOCURSOR('<?xml version="1.0"?>'+CHR(13)+STREXTRACT(lcWebPage,"<wiki>","</wiki>"), "Topics")
XMLTOCURSOR(lcWebPage, "Topics")

* Bug fix - 19-Aug-2003 (Induction day, 24 years ago)
* Sometimes, there are no new topics, so we get an "Alias 'Topics' does not exist" below
NOTE Could NOT use a RETURN here within the TRY... CATCH so remainder of code
* is within (ugly) IF...ENDIF block.
IF USED("Topics")

* Create an output file with header, named FoxWikiYYYYMMDDHHMMSS.txt
* lcFileName = "FoxWiki" + TTOC(DATETIME(),1)+".txt" - debugging
lcFileName = "FoxWiki.rdf"

* RSS 1.0 has an items TOC in the header *

LOCAL lcHeadXML

* Heading
SET TEXTMERGE ON 
TEXT TO lcHeadXML TEXTMERGE noshow
<items>
<rdf:Seq>
ENDTEXT

SELECT topics
SCAN
* Body
TEXT TO lcHeadXML TEXTMERGE NOSHOW ADDITIVE 

<rdf:li rdf:resource="<<ALLTRIM(topics.link)>>" />

ENDTEXT
ENDSCAN && topics

* Footer
TEXT TO lcHeadXML TEXTMERGE NOSHOW  ADDITIVE 

</rdf:Seq>
</items>
ENDTEXT



* Create/update a table of the topics and brief description of each
IF NOT FILE("FoxWiki.dbf")
  SELECT 0
  CREATE TABLE FoxWiki (cTitle c(128), mDesc M, cLink c(128), tUpdated T)
  INDEX ON cTitle TAG cTitle
ELSE  && exists, open it
  SELECT 0
  USE FoxWiki
ENDIF

SELECT topics
SCAN

  * Determine if the topic has already been scanned

  IF SEEK(topics.NAME,"FoxWiki","ctitle")
    * \\ this leave the text alone, assuming (!) the change is added
    * to the end of the topic, or otherwise doesn't affect topic.
    UPDATE FoxWiki SET tUpdated=Topics.Updated WHERE FoxWiki.cTitle=Topics.Name
    * already found, skip it
  ELSE
    * lcWebPage = ReadURL(topics.xmllink)

   	lcWebPage = lowikiwebservice.GetTopicText(topics.name)

    lcText = HTMLText2(STREXTRACT(lcWebPage,"<topictext><![CDATA[","]]></topictext>"))
    INSERT INTO FoxWiki VALUES (topics.NAME, lcText, topics.LINK, topics.Updated)
  ENDIF

ENDSCAN

* Convert field names with a Select
* SELECT name as Title, name as description, link FROM ("Topics") INTO CURSOR Item
SELECT topics.link as About, ;
  topics.NAME AS TITLE, ;
  FoxWiki.mDesc AS DESCRIPTION, ;
  topics.LINK AS LINK, ;
  "unknown" as Creator, ;
  ISO8601DateTime(updated) as pubDate;
  FROM topics INNER JOIN FoxWiki ON topics.NAME = FoxWiki.cTITLE ;
  INTO CURSOR ITEM

* debugging: change to produce one record, for testing
* CURSORTOXML("Item", "lcXML", 1,0,1,"")
CURSORTOXML("Item", "lcXML",1,0+8,0,"")

lcXML = STREXTRACT(lcXML, "<VFPData>", "</VFPData>")

* Change the About, data and Creator fields
* <item rdf:about=""> uses an about attribute of the item element.
* the CursortoXML creates an about element we strip the tags off of.
lcXML = STRTRAN(lcXML ,"<item>"+CHR(13)+CHR(10)+CHR(9)+CHR(9)+"<about>","<item rdf:about="+["])
lcXML = STRTRAN(lcXML ,"</about>", [">])

lcXML = STRTRAN(lcXML ,"pubdate>","dc:date>")
lcXML = STRTRAN(lcXML ,"creator>","dc:creator>")

******************
*** XML Header ***
******************

SET TEXTMERGE TO memvar lcContents
SET TEXTMERGE ON noshow
\<?xml version="1.0" encoding="iso-8859-1"?>
\
\<rdf:RDF
\  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
\  xmlns:dc="http://purl.org/dc/elements/1.1/"
\  xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
\  xmlns:admin="http://webns.net/mvcb/"
\  xmlns:cc="http://web.resource.org/cc/"
\  xmlns="http://purl.org/rss/1.0/">
\  
\<channel rdf:about="http://fox.wikis.com/">
\<title>FoxForum Wiki</title>
\<link>http://fox.wikis.com/</link>
\<description>Visual FoxPro Wiki, community supported knowledgebase</description>
\<dc:language>en-us</dc:language>
\<dc:creator>Steven Black</dc:creator>
\<dc:date><<ISO8601DateTime(DATETIME())>></dc:date>
\<admin:generatorAgent rdf:resource="http://msdn.microsoft.com/vfoxpro" />
\<admin:errorReportsTo rdf:resource="mailto:tedroche@tedroche.com" />
\<<lcHeadXML>>
\</channel>
\  
\  <<lcXML>>
\  
\</rdf:RDF>
SET TEXTMERGE to
SET TEXTMERGE off

* Write it out
lcSafety = SET("Safety")
SET SAFETY OFF
STRTOFILE(lcContents, lcFileName, 0)
SET SAFETY &lcSafety

* display output file
* MODIFY FILE (lcFileName) NOWAIT

ELSE
  * No new topics, bail
ENDIF


CATCH
  lcErrorMessage = TRANSFORM(DATETIME())  + CHR(13) +CHR(10) + ;
                   TRANSFORM(ERROR()) + SPACE(1) + CHR(13) +CHR(10) + ;
                   MESSAGE() + " - " + MESSAGE(1) + CHR(13) + CHR(10)
  STRTOFILE(lcErrorMessage, "FoxWikiRSS10.ERR",1)
  AERROR(laError)
  LIST MEMORY LIKE laError TO FILE FoxWiki.err ADDITIVE NOCONSOLE 
  
FINALLY
ENDTRY
