**********************************************************************
* Program....: LISTITEMS.PRG
* Version....:
* Author.....: Ted Roche
* Date.......: 05 September 2003, 17:15:58
* Notice.....: Copyright  2003 by Ted Roche, under the 
* ...........: Creative Commons Attribution - ShareAlike 1.0 license
* ...........: http://creativecommons.org/licenses/by-sa/1.0/
* Compiler...: Visual FoxPro 08.00.0000.2521 for Windows
* Abstract...:
* Changes....:
* Parameters.:
* Purpose....: List the title of the <item>
* ...........: elements in an XML RSS feed, using VFP string 
* ...........: functions
**********************************************************************
LOCAL lcFilename as String, ;
      lnCount as Integer, ;
      lcXML as String, ;
      lcString as String
      
* Get a file
lcFileName = GETFILE()
IF NOT FILE(lcFileName)
  RETURN
ENDIF
lcXML = FILETOSTR(lcFileName)

* RSS 1.0 has an items collection; skip it
IF "<items" $ lcXML
  lnCount = 2
ELSE
  lnCount = 1
ENDIF

* List the item elements
lcString = STREXTRACT(lcXML, "<item", "</item>", lnCount)
DO WHILE NOT EMPTY(lcString)
  ? STREXTRACT(lcString, "<title", "</title>")
  lnCount = lnCount + 1
  lcString = STREXTRACT(lcXML, "<item", "</item>", lnCount)
ENDDO