**********************************************************************
* Program....: RSS20GEN.PRG
* Version....: 1.0.0.1
* Author.....: Ted Roche
* Date.......: 03 September 2003, 15:26:14
* Notice.....: Copyright  2003, All Rights Reserved.
* Compiler...: Visual FoxPro 08.00.0000.2521 for Windows
* Abstract...:
* Changes....:
* Parameters.:
* Purpose....: Generate RSS 2.0 from incoming cursor
* Based, vaguely, on original sample code from Mike Helland 
* at http://fox.wikis.com/wc.dll?Wiki~RaggedXMLProcessingInVFP~VFP
**********************************************************************

RETURN .t.  && comment out for testing

* Inputs: Cursors of channel header information
*         Cursor of new itesm

* Outputs: RSS XML string

*** TEST HEADER ***
CREATE CURSOR curHeader (cTitle c(40), cLink c(254), mDesc M)
INSERT INTO curHeader (cTitle, cLink, mDesc) VALUES ;
                      ("The FoxForum Wiki", ;
                       "http://fox.wikis.com", ;
                       "The online community for interactive and persistant FoxPro knowledge." ;
                       )
*** TEST ITEMS ***
CREATE CURSOR curItem (title c(40), description M, link c(254), updated T)
INSERT INTO curItem VALUES ("Test Item #1", "This is the body of test item #1.", "http://example.com/1", DATETIME())
INSERT INTO curItem VALUES ("Test Item #2", "This is the body of test item #2.", "http://example.com/2", DATETIME())
INSERT INTO curItem VALUES ("Test Item #3", "This is the body of test item #3.", "http://example.com/3", DATETIME())

loGenRSS = CREATEOBJECT("RSS20Generator")
loXML = loGenRSS.ProcessRSS()
lcOutputFileName = "testrss20.xml"
lcOutputFileName = FULLPATH(lcOutputFilename)
loXML.Save(lcOutputFilename)
* STRTOFILE(loXML.xml, lcOutputFilename)
MODIFY FILE (lcOutputFilename)
* ShellExe(lcOutputFilename)  && ShellExe is a UDF to invoke the 
* Win32API ShellExecute function

***********************************************************
* Class Definition: RSS20Generator
***********************************************************

DEFINE CLASS RSS20Generator as Custom
oXML = NULL

********
* Init *
********
PROCEDURE Init

ENDPROC && Init

********************************
* ProcessRSS()                 *
* Template processing method   *
********************************

PROCEDURE ProcessRSS()
THIS.CreateDoc()
THIS.AddChannelInfo()
THIS.AddHeaderItems()
THIS.AddBodyItems()
RETURN THIS.oXML

ENDPROC && ProcessRSS

*************
* CreateDoc *
*************
* Creates the base XMLDOM object, 
* XML declaration, RSS root
* and version declarations

PROCEDURE CreateDoc()

LOCAL loXML as MSXML.DOMDocument40
LOCAL loDocument, loAttribute

loXML = newobject('msxml2.domdocument.4.0')
loXml.async = .f.

* Create the RSS root
loNewItem = loXML.CreateProcessingInstruction([xml], [version='1.0' encoding='iso-8859-1'])
loXML.appendChild(loNewItem)

loDocument = loXml.createElement('rss') 
loXML.appendChild(loDocument)

* Add the RSS Version number
loAttribute = loXML.createAttribute([version])
loAttribute.value="2.0"
loDocument.attributes.setNamedItem(loAttribute)

* Release object references
STORE null TO loAttribute, loDocument

* Store the XMLDOM object 
THIS.oXml = loXML

ENDPROC && CreateDoc()

******************
* AddChannelInfo *
******************
* Builds the channel element 
* from the curHeader cursor
*

PROCEDURE AddChannelInfo

LOCAL loXML, loElement, loAttribute, loChannel, loDocument
loXML = THIS.oXML
loDocument = loXML.childNodes.item(1)

* Add the channel sub-element
loElement = loXML.createElement("channel")
loChannel = loDocument.appendChild(loElement)

* Add the title sub-element
loElement = loXML.createElement("title")
loElement.nodeTypedValue = curHeader.cTitle  && "FoxForum Wiki"
loChannel.appendChild(loElement)

* Add the link sub-element
loElement = loXML.createElement("link")
loElement.nodeTypedValue = ALLTRIM(curHeader.cLink) && "http://fox.wikis.com/"
loChannel.appendChild(loElement)

* Add the description sub-element
loElement = loXML.createElement("description")
loElement.nodeTypedValue = curHeader.mDesc && "Visual FoxPro Wiki, community supported knowledgebase"
loChannel.appendChild(loElement)

* Add the date sub-element
loElement = loXML.createElement("lastBuildDate")
loElement.nodeTypedValue = rfc822Date(DATETIME())
loChannel.appendChild(loElement)

ENDPROC && AddChannelInfo

******************
* AddHeaderItems *
******************
* Adds the Items sub-element (//RDF/channel/Items)
* that lists the links for each item to follow
* in the body of the RSS
*

PROCEDURE AddHeaderItems()

RETURN .T. && RSS 2.0 doesn't have header items

ENDPROC && AddHeaderItems

****************
* AddBodyItems *
****************
* Adds the individual items for each
* article

PROCEDURE AddBodyItems()

LOCAL loXML, loElement, loAttribute, loItem, loDocument, loCDATA
loXML = THIS.oXML
loDocument = loXML.selectSingleNode("//channel")

* Add Items to channel
SELECT CurItem
SCAN  && curItem

loElement = loXML.createElement("item")
loItem = loDocument.appendChild(loElement)

* Add the title sub-element
loElement = loXML.createElement("title")
loElement.nodeTypedValue = ALLTRIM(CurItem.title)
loItem.appendChild(loElement)

* Add the description sub-element
loElement = loXML.createElement("description")
loCDATA = loXML.createCDATASection(ALLTRIM(curItem.Description))
loElement.appendChild(loCDATA)
loItem.appendChild(loElement)

* Add the link sub-element
loElement = loXML.createElement("link")
loElement.nodeTypedValue = ALLTRIM(CurItem.Link)
loItem.appendChild(loElement)

* Add the date sub-element
loElement = loXML.createElement("pubDate")
loElement.nodeTypedValue = rfc822Date(CurItem.Updated)
loItem.appendChild(loElement)

ENDSCAN  && curItem

ENDPROC && AddBodyItems()

******************
* Error handling *
******************

PROCEDURE Error(tnError, tcMethod, tnLine)
LOCAL lcError as String
lcError = CHR(13)+CHR(10) + TTOC(DATETIME()) + CHR(13)+CHR(10) + ;
          "Error " + TRANSFORM(tnError) + ;
          " in method " + tcMethod + ;
          " at line " + TRANSFORM(tnLine)
          
IF SYS(2335) = '1'  OR ; && unattended server mode
   VERSION(2) = 0 OR ; && runtime version
   _screen.Visible= .F.
   
  * Log the error to disk
  STRTOFILE(lcError, JUSTSTEM(SYS(16))+".err", .T.)
  QUIT 
ELSE  && not hidden
  MESSAGEBOX(lcError)
  CANCEL
ENDIF


ENDPROC && Error()

ENDDEFINE && CLASS RSS20Generator as Custom
