**********************************************************************
* Program....: DRIVER20.PRG
* Version....:
* Author.....: Ted Roche
* Date.......: 25 January 2004, 15:27:03
* Notice.....: Copyright  2004 by Ted Roche, under the 
* ...........: Creative Commons Attribution - ShareAlike 1.0 license
* ...........: http://creativecommons.org/licenses/by-sa/1.0/
* Compiler...: Visual FoxPro 08.00.0000.3117 for Windows
* Abstract...:
* Changes....:
* Parameters.:
* Purpose....: Drives the consumption of web content and 
* ...........: generation of RSS
**********************************************************************

LOCAL lcFileName, loGenRSS, loXML
* Open the table if not already open
IF NOT USED("trweb")
  USE trweb IN 0
ENDIF
SELECT trweb 

* Extract articles and rename fields
SELECT ctitle as title, ;
       mContent as description, ;
       cLink as link, ;
       tupdated as updated ;
  FROM trweb ;
  INTO CURSOR curItem ;
 ORDER BY updated descending
 
* Create the header cursor for the RSS feed information
CREATE CURSOR curHeader (cTitle c(40), cLink c(254), mDesc M)
INSERT INTO curHeader (cTitle, cLink, mDesc) VALUES ;
                      ("Ted Roche & Associates, LLC Web Site", ;
                       "http://www.tedroche.com.com", ;
                       "Changes to the web site of Ted Roche & Associates, LLC" ;
                       )

* Generate the XML and launch it
loGenRSS = NewOBJECT("RSS20Generator","RSS20Gen.Prg")
loXML = loGenRSS.ProcessRSS()
lcFileName = FULLPATH("TRWeb.XML")
loXML.Save(lcFileName)
ShellExe(lcFileName)
